package com.clx.performance.extranal.order.impl;

import com.clx.order.feign.InvoicingCompanyFeign;
import com.clx.order.vo.pc.carrier.InvoicingCompanyVO;
import com.clx.performance.extranal.order.InvoicingCompanyService;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class InvoicingCompanyServiceImpl implements InvoicingCompanyService {
    @Autowired
    private InvoicingCompanyFeign invoicingCompanyFeign;

    @Override
    public Optional<InvoicingCompanyVO> getInvoicingCompany(int  id) {
        return Optional.ofNullable(invoicingCompanyFeign.getInvoicingCompany(id))
                .filter(Result::succeed)
                .map(Result::getData);
    }

    @Override
    public InvoicingCompanyVO getInvoicingCompanyByGroupCode(String companyGroupCode) {
        return Optional.of(invoicingCompanyFeign.getInvoicingCompanyByGroupCode(companyGroupCode))
                .filter(Result::succeed)
                .map(Result::getData)
                .orNull();
    }

    @Override
    public Integer getInvoicingConfigTypeByOrderNo(String orderNo) {
        return Optional.of(invoicingCompanyFeign.getInvoicingConfigTypeByOrderNo(orderNo))
                .filter(Result::succeed)
                .map(Result::getData)
                .orNull();
    }
}
