package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.clx.performance.dao.OrderChildExceptionReportOperationLogDao;
import com.clx.performance.mapper.OrderChildExceptionReportOperationLogMapper;
import com.clx.performance.model.OrderChildExceptionReportOperationLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 运单图片
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildExceptionReportOperationLogDaoImpl extends BaseDaoImpl<OrderChildExceptionReportOperationLogMapper, OrderChildExceptionReportOperationLog, Integer> implements OrderChildExceptionReportOperationLogDao {
    @Override
    public List<OrderChildExceptionReportOperationLog> getLogs(String reportNo) {
        LambdaQueryWrapper<OrderChildExceptionReportOperationLog> query = new LambdaQueryWrapper<>();
        query.eq(OrderChildExceptionReportOperationLog::getReportNo,reportNo);
        query.orderByDesc(OrderChildExceptionReportOperationLog :: getId);
        return baseMapper.selectList(query);
    }
}
