package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.PageExceptionReportParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.clx.performance.dao.OrderChildExceptionReportDao;
import com.clx.performance.mapper.OrderChildExceptionReportMapper;
import com.clx.performance.model.OrderChildExceptionReport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.Objects;

/**
 * @author kavin
 * Date 2024-10-22
 * Time 10:38
 */
@Repository
public class OrderChildExceptionReportDaoImpl extends BaseDaoImpl<OrderChildExceptionReportMapper, OrderChildExceptionReport, Integer> implements OrderChildExceptionReportDao {
    @Override
    public OrderChildExceptionReport findByThirdReportNoAndSource(Integer source, String thirdReportNo) {
        LambdaQueryWrapper<OrderChildExceptionReport> query = new LambdaQueryWrapper<>();
        query.eq(OrderChildExceptionReport :: getSource,source);
        query.eq(OrderChildExceptionReport ::getThirdReportNo,thirdReportNo);
        return baseMapper.selectOne(query);
    }

    @Override
    public IPage<OrderChildExceptionReport> pageExceptionReport(PageExceptionReportParam param) {
        LambdaQueryWrapper<OrderChildExceptionReport> query = new LambdaQueryWrapper<>();
        query.eq(StringUtils.isNotBlank(param.getThirdReportNo()),OrderChildExceptionReport :: getThirdReportNo,param.getThirdReportNo());
        query.eq(Objects.nonNull(param.getSource()),OrderChildExceptionReport ::getSource,param.getSource());
        query.eq(Objects.nonNull(param.getStatus()),OrderChildExceptionReport ::getStatus,param.getStatus());
        query.eq(StringUtils.isNotBlank(param.getChildNo()),OrderChildExceptionReport ::getChildNo,param.getChildNo());
        query.eq(StringUtils.isNotBlank(param.getTruckNoOrMobile()),OrderChildExceptionReport ::getTruckNoOrMobile,param.getTruckNoOrMobile());
        query.ge(StringUtils.isNotBlank(param.getBeginTime()),OrderChildExceptionReport ::getCreateTime,param.getBeginTime());
        query.le(StringUtils.isNotBlank(param.getEndTime()),OrderChildExceptionReport ::getCreateTime,param.getEndTime());
        query.orderByDesc(OrderChildExceptionReport :: getId);
        return baseMapper.selectPage(Page.of(param.getPage(), param.getPageSize()),query);
    }
}
