package com.clx.performance.controller.temp;

import com.clx.performance.service.thirdparty.nbbank.NbBankService;
import com.clx.performance.vo.pc.nbbank.NbBankOrderPayResultVO;
import com.clx.performance.vo.pc.nbbank.NbBankOrderResultVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/bank")
public class TempBankController {

    @Autowired
    private NbBankService bankService;

    @Operation(summary = "转账支付", description = "<br>By:艾庆国")
    @RequestMapping(value = "/orderTransferPay", method = RequestMethod.POST)
    public Result<NbBankOrderPayResultVO> directBankTransferOrder() {

        return Result.ok(bankService.orderTransferPay(1));
    }

    @Operation(summary = "订单支付", description = "<br>By:艾庆国")
    @RequestMapping(value = "/orderDirectPay", method = RequestMethod.POST)
    public Result<NbBankOrderPayResultVO> orderDirectPay() {

//        return Result.ok(bankService.orderDirectPay(null,2,"313332082914","86041110000076809", "黑玫瑰"));
//        return Result.ok(bankService.orderDirectPay(null,2,"313332082914","86041110000075926", "客户客户"));
        return Result.ok(bankService.orderDirectPay(null,"",1,"313332082914","86031110000180611", "槟榔王"));
    }

    @Operation(summary = "订单支付1", description = "<br>By:艾庆国")
    @RequestMapping(value = "/orderDirectPay1", method = RequestMethod.POST)
    public Result<NbBankOrderPayResultVO> orderDirectPay1(String payAcctNo, String payAcctNm) {
//        return Result.ok(bankService.orderDirectPay(null,2,"313332082914","86041110000076809", "黑玫瑰"));
//        return Result.ok(bankService.orderDirectPay(null,2,"313332082914","86041110000075926", "客户客户"));
        return Result.ok(bankService.orderDirectPay(null,"",1,"313332082914",payAcctNo, payAcctNm));
    }

    @Operation(summary = "查询", description = "<br>By:艾庆国")
    @RequestMapping(value = "/getResult", method = RequestMethod.POST)
    public Result<NbBankOrderResultVO> getResult(String merSeqNo) {

        return Result.ok(bankService.getResult(merSeqNo));
    }

    @Operation(summary = "调账", description = "<br>By:艾庆国")
    @RequestMapping(value = "/adjust", method = RequestMethod.POST)
    public Result<NbBankOrderResultVO> adjust(String orgMerSeqNo, Integer amount) {

        return Result.ok(bankService.adjust(orgMerSeqNo,amount));
    }

    @Operation(summary = "退款", description = "<br>By:艾庆国")
    @RequestMapping(value = "/refund", method = RequestMethod.POST)
    public Result<NbBankOrderResultVO> refund(Integer type, String orgMerSeqNo, Integer amount, String orgTransSeqNo) {

        return Result.ok(bankService.refund(type,orgMerSeqNo,amount,orgTransSeqNo));
    }

    @Operation(summary = "回调", description = "<br>By:艾庆国")
    @RequestMapping(value = "/notify", method = RequestMethod.POST)
    public Result notify(NbBankOrderResultVO param) {
        bankService.orderPayCallback(param.getMerSeqNo(), param.getTransSeqNo(),
                param.getAmount(), param.getAmount(), param.getStatus(), param.getSignNo());
        return Result.ok();
    }

}
