package com.clx.performance.controller.pc;

import com.clx.performance.service.OrderChildPoundLogService;
import com.clx.performance.vo.pc.OrderChildPoundLogVO;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotBlank;
import java.util.List;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/poundLog")
@Validated
@Tag(name = "承运端-磅单审核")
@AllArgsConstructor
public class OrderChildPoundLogController {


    private final OrderChildPoundLogService orderChildPoundLogService;

    @Operation(summary = "磅单审核日志列表",description = "<br>By:李瑞新")
    @GetMapping("/getPoundLogList")
    public Result<List<OrderChildPoundLogVO>> getPoundLogList(@NotBlank(message = "运单编号不能为空") String childNo) {
        return Result.ok(orderChildPoundLogService.getPoundLogList(childNo));
    }

}
