package com.clx.performance.controller.pc;

import com.clx.performance.param.pc.IntegralRecordAddParam;
import com.clx.performance.service.IntegralRecordService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral")
@Validated
@Tag(name = "承运端-积分记录")
@AllArgsConstructor
public class IntegralRecordController {

    @Autowired
    private IntegralRecordService integralRecordService;


    @Operation(summary = "新增积分记录", description = "<br>By:艾庆国")
    @PostMapping(value = "addIntegral")
    public Result<Void> addRecord(@RequestBody @Validated IntegralRecordAddParam param) {

        integralRecordService.addDriverReportRecord(param);

        return Result.ok();
    }

}
