package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.annotation.ResetPassword;
import com.clx.performance.param.app.CheckMobileParam;
import com.clx.performance.param.app.InformationParam;
import com.clx.performance.param.app.ResetPasswordParam;
import com.clx.performance.param.app.SendMobileCaptchaParam;
import com.clx.performance.param.pc.PageAppPrepaidFreightAccountParam;
import com.clx.performance.service.OwnerAccountService;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/app/owner")
@Validated
@AllArgsConstructor
@Tag(name = "APP-货主资金管理")
public class AppOwnerAccountController {

    private final OwnerAccountService ownerAccountService;


    @Operation(summary = "APP货主流水", description = "<br>By:胡宇帆")
    @PostMapping("/prepaidFreightOwnerAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> prepaidFreightOwnerAccountPageList(@RequestBody PageAppPrepaidFreightAccountParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.prepaidFreightOwnerAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "发送手机验证码", description = "<br>By:胡宇帆")
    @PostMapping("/sendMobileCaptcha")
    @ResetPassword(name = "sendMobileCaptcha")
    public Result<String> sendMobileCaptcha(@RequestBody SendMobileCaptchaParam param) {
        String token = ownerAccountService.sendMobileCaptcha(param);
        return Result.ok(token);
    }

    @Operation(summary = "验证手机号验证码", description = "<br>By:胡宇帆")
    @PostMapping("/checkMobile")
    @ResetPassword(name = "checkMobile")
    public Result<String> checkMobile(@RequestBody CheckMobileParam param) {
        String token = ownerAccountService.checkMobile(param);
        return Result.ok(token);
    }

    @Operation(summary = "验证营业执照编号", description = "<br>By:胡宇帆")
    @PostMapping("/checkBusinessLicenseNumber")
    @ResetPassword(name = "checkBusinessLicenseNumber")
    public Result<String> checkBusinessLicenseNumber(@RequestBody InformationParam param) {
        String token = ownerAccountService.checkBusinessLicenseNumber(param);
        return Result.ok(token);
    }

    @Operation(summary = "修改交易密码", description = "<br>By:胡宇帆")
    @PostMapping("/resetPassword")
    @ResetPassword(name = "resetPassword")
    public Result<Object> resetPassword(@RequestBody ResetPasswordParam param) {
        ownerAccountService.resetPassword(param);
        return Result.ok();
    }
}
