package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.AppGoodsOrderSearchParam;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.service.OrderGoodsTruckBindService;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.app.OrderGoodsTodaySumVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/app/goodsOrder")
@Validated
@AllArgsConstructor
@Tag(name = "APP-货单")
public class AppGoodsOrderController {

    private final OrderGoodsService orderGoodsService;

    private final OrderGoodsTruckBindService orderGoodsTruckBindService;


    @Operation(summary = "查看货单详情", description = "<br>By:胡宇帆")
    @GetMapping("/getOrderGoodsInfo")
    @UnitCovert(param = false)
    public Result<OrderGoodsVO> getOrderGoodsInfo(@Validated @RequestParam String orderGoodsNo) {
        return Result.ok(orderGoodsService.getOrderGoodsInfoByOrderGoodsNoForAPP(orderGoodsNo));
    }

    @Operation(summary = "APP首页货单列表", description = "<br>By:胡宇帆")
    @PostMapping("/indexOrderGoodsList")
    @UnitCovert(param = false)
    public Result<PageData<OrderGoodsAPPVO>> indexOrderGoodsList(@RequestBody OrderGoodsListPageParam orderGoodsListPageParam) {
        IPage<OrderGoodsAPPVO> page = orderGoodsService.indexOrderGoodsList(orderGoodsListPageParam);

        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

    @Operation(summary = "APP首页搜索", description = "<br>By:胡宇帆")
    @PostMapping("/indexOrderGoodsListSearch")
    @UnitCovert(param = false)
    public Result<PageData<OrderGoodsAPPVO>> indexOrderGoodsListSearch(@RequestBody AppGoodsOrderSearchParam param) {
        IPage<OrderGoodsAPPVO> page = orderGoodsService.indexOrderGoodsListSearch(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "司机端无接单位置上报", description = "<br>By:胡宇帆")
    @GetMapping("/getCancelOrderGoods")
    public Result<List<OrderGoodsAPPVO>> getCancelOrderGoods(@RequestParam(value = "userNo") Long userNo) {
        return Result.ok(orderGoodsTruckBindService.getCancelOrderGoods(userNo));
    }

    @Operation(summary = "司机端获取当日已接单（包含已取消）、今日预估利润", description = "br>By:马路路")
    @GetMapping("/getTodayOrderGoodsSum")
    @UnitCovert(param = false)
    public Result<OrderGoodsTodaySumVO> getTodayOrderGoodsSum () {
        return Result.ok(orderGoodsService.getTodayOrderGoodsSum());
    }
}
