package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyConstants;
import org.springframework.amqp.core.*;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author xujianke
 * @date 2017年9月14日
 * @description rabbit配置文件
 */
@Configuration
public class RabbitBeanConfig {
    /**
     * 订单已挂单队列
     */
    @Bean
    public Queue orderPostedQueue() {
        return new Queue(RabbitKeyConstants.ORDER_POSTED_QUEUE, true);
    }
    /**
     * 订单已挂单交换机
     **/
    @Bean
    public DirectExchange orderPostedExchange() {
        return new DirectExchange(RabbitKeyConstants.ORDER_POSTED_EXCHANGE);
    }
    /**
     * 订单已挂单绑定
     */
    @Bean
    public Binding orderPostedExchangeBind() {
        return BindingBuilder.bind(orderPostedQueue()).to(orderPostedExchange()).with(RabbitKeyConstants.ORDER_POSTED_ROUTE_KEY);
    }


    @Bean
    public Queue orderOnQueue() {
        return new Queue(RabbitKeyConstants.ORDER_ON_QUEUE, true, false, false);
    }

    /**
     * 订单挂单中交换机
     **/
    @Bean
    public CustomExchange orderOnExchange() {
        Map<String, Object> arguments = new HashMap<>();
        //设置路由模式 direct模式
        arguments.put("x-delayed-type", "direct");
        return new CustomExchange(RabbitKeyConstants.ORDER_ON_EXCHANGE,"x-delayed-message", true, false, arguments);
    }

    /**
     * 订单挂单中绑定
     */
    @Bean
    public Binding orderOnExchangeBind(@Qualifier("orderOnQueue")Queue queue,@Qualifier("orderOnExchange")CustomExchange customExchange) {
        return BindingBuilder.bind(queue).to(customExchange).with(RabbitKeyConstants.ORDER_ON_ROUTE_KEY).noargs();
    }


    /**
     * 处理延迟消息货单挂单
     */
    @Bean
    public Queue orderGoodsOnDeadQueue() {
        return new Queue(RabbitKeyConstants.ORDER_GOODS_ON_DEAD_QUEUE, true, false, false);
    }

    /**
     * 货单挂单中交换机：处理延迟消息
     **/
    @Bean
    public CustomExchange orderGoodsOnDeadExchange() {
        Map<String, Object> arguments = new HashMap<>();
        //设置路由模式 direct模式
        arguments.put("x-delayed-type", "direct");
        return new CustomExchange(RabbitKeyConstants.ORDER_GOODS_ON_DEAD_EXCHANGE,"x-delayed-message", true, false, arguments);
    }

    //绑定交换机,队列和routingKey
    @Bean
    public Binding delayedQueueBindingDelayedExchange(@Qualifier("orderGoodsOnDeadQueue")Queue queue,@Qualifier("orderGoodsOnDeadExchange")CustomExchange customExchange) {
        return BindingBuilder.bind(queue).to(customExchange).with(RabbitKeyConstants.ORDER_GOODS_ON_DEAD_ROUTE_KEY).noargs();
    }

    /**
     * 订单取消队列
     */
    @Bean
    public Queue orderCancelQueue() {
        return new Queue(RabbitKeyConstants.ORDER_CANCEL_QUEUE, true, false, false);
    }

    /**
     * 订单取消队列交换机
     **/
    @Bean
    public DirectExchange orderCancelExchange() {
        return new DirectExchange(RabbitKeyConstants.ORDER_CANCEL_EXCHANGE);
    }

    /**
     * 订单取消队列绑定
     */
    @Bean
    public Binding orderCancelExchangeBind() {
        return BindingBuilder.bind(orderCancelQueue()).to(orderCancelExchange()).with(RabbitKeyConstants.ORDER_CANCEL_ROUTE_KEY);
    }

    /**
     * 运单同步网络货运队列
     */
    @Bean
    public Queue orderChildSyncTransportQueue() {
        return new Queue(RabbitKeyConstants.ORDER_CHILD_SYNC_TRANSPORT_QUEUE, true, false, false);
    }

    /**
     * 运单同步网络货运交换机
     **/
    @Bean
    public DirectExchange orderChildSyncTransportExchange() {
        return new DirectExchange(RabbitKeyConstants.ORDER_CHILD_SYNC_TRANSPORT_EXCHANGE);
    }

    /**
     * 运单同步网络货运绑定
     */
    @Bean
    public Binding orderChildSyncTransportExchangeBind() {
        return BindingBuilder.bind(orderChildSyncTransportQueue()).to(orderChildSyncTransportExchange()).with(RabbitKeyConstants.ORDER_CHILD_SYNC_TRANSPORT_ROUTE_KEY);
    }

    /**
     * 处理延迟消息orderGoodsTruckBind
     */
    @Bean
    public Queue orderGoodsTruckBindQueue() {
        return new Queue(RabbitKeyConstants.ORDER_TRUCK_BIND_LAZY_QUEUE, true, false, false);
    }

    /**
     * 处理延迟消息orderGoodsTruckBind
     **/
    @Bean
    public CustomExchange orderGoodsTruckBindExchange() {
        Map<String, Object> arguments = new HashMap<>();
        //设置路由模式 direct模式
        arguments.put("x-delayed-type", "direct");
        return new CustomExchange(RabbitKeyConstants.ORDER_TRUCK_BIND_LAZY_EXCHANGE,"x-delayed-message", true, false, arguments);
    }

    //绑定交换机,队列和routingKey
    @Bean
    public Binding orderGoodsTruckBindBindingDelayedExchange(@Qualifier("orderGoodsTruckBindQueue")Queue queue,@Qualifier("orderGoodsTruckBindExchange")CustomExchange customExchange) {
        return BindingBuilder.bind(queue).to(customExchange).with(RabbitKeyConstants.ORDER_TRUCK_BIND_LAZY_ROUTE_KEY).noargs();
    }

    /**
     * 货主借款支付处理
     */
    @Bean
    public Queue ownerLoanPayQueue() {
        return new Queue(RabbitKeyConstants.OWNER_LOAN_PAY_QUEUE, true, false, false);
    }

    /**
     * 货主借款支付处理
     **/
    @Bean
    public DirectExchange ownerLoanExchange() {
        return new DirectExchange(RabbitKeyConstants.OWNER_LOAN_EXCHANGE);
    }

    /**
     * 货主借款支付处理
     */
    @Bean
    public Binding ownerLoanPayBind() {
        return BindingBuilder.bind(ownerLoanPayQueue()).to(ownerLoanExchange()).with(RabbitKeyConstants.OWNER_LOAN_PAY_ROUTE_KEY);
    }

    /**
     * 货主还款队列
     * @return
     */
    @Bean
    public Queue ownerRepaymentQueue() {
        return new Queue(RabbitKeyConstants.OWNER_REPAYMENT_QUEUE, true, false, false);
    }
    /**
     * 货主还款bind
     * @return
     */
    @Bean
    public Binding ownerRepaymentBind() {
        return BindingBuilder.bind(ownerRepaymentQueue()).to(ownerLoanExchange()).with(RabbitKeyConstants.OWNER_REPAYMENT_ROUTE_KEY);
    }


    /**
     * 货主借款冻结释放队列
     * @return
     */
    @Bean
    public Queue ownerLoanThawQueue() {
        return new Queue(RabbitKeyConstants.OWNER_LOAN_THAW_QUEUE, true, false, false);
    }
    /**
     * 货主还款bind
     * @return
     */
    @Bean
    public Binding ownerLoanThawBind() {
        return BindingBuilder.bind(ownerLoanThawQueue()).to(ownerLoanExchange()).with(RabbitKeyConstants.OWNER_LOAN_THAW_ROUTE_KEY);
    }



    /**
     * 监听货单同步履约进度表
     */
    @Bean
    public Queue syncPerformanceProgress4OrderGoodsQueue() {
        return new Queue(RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_GOODS_QUEUE,
                true, false, false);
    }
    /**
     * 监听货单同步履约进度表
     **/
    @Bean
    public DirectExchange syncPerformanceProgress4OrderGoodsExchange() {
        return new DirectExchange(RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_GOODS_EXCHANGE);
    }
    /**
     * 监听货单同步履约进度表
     */
    @Bean
    public Binding syncPerformanceProgress4OrderGoodsBind() {
        return BindingBuilder.bind(syncPerformanceProgress4OrderGoodsQueue()).to(syncPerformanceProgress4OrderGoodsExchange())
                .with(RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_GOODS_ROUTING_KEY);
    }

    /**
     * 监听运单同步履约进度表
     */
    @Bean
    public Queue syncPerformanceProgress4OrderChildQueue() {
        return new Queue(RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_CHILD_QUEUE,
                true, false, false);
    }
    /**
     * 监听运单同步履约进度表
     **/
    @Bean
    public DirectExchange syncPerformanceProgress4OrderChildExchange() {
        return new DirectExchange(RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_CHILD_EXCHANGE);
    }
    /**
     * 监听运单同步履约进度表
     */
    @Bean
    public Binding syncPerformanceProgress4OrderChildBind() {
        return BindingBuilder.bind(syncPerformanceProgress4OrderChildQueue()).to(syncPerformanceProgress4OrderChildExchange())
                .with(RabbitKeyConstants.SYNC_PERFORMANCE_PROGRESS_FOR_ORDER_CHILD_ROUTING_KEY);
    }


    /**
     * 保存货单调价表
     */
    @Bean
    public Queue saveOrderGoodsAdjustmentPriceQueue() {
        return new Queue(RabbitKeyConstants.SAVE_ORDER_GOODS_ADJUSTMENT_PRICE_QUEUE,
                true, false, false);
    }
    /**
     * 保存货单调价表
     **/
    @Bean
    public DirectExchange saveOrderGoodsAdjustmentPriceExchange() {
        return new DirectExchange(RabbitKeyConstants.SAVE_ORDER_GOODS_ADJUSTMENT_PRICE_EXCHANGE);
    }
    /**
     *保存货单调价表
     */
    @Bean
    public Binding saveOrderGoodsAdjustmentPriceBind() {
        return BindingBuilder.bind(saveOrderGoodsAdjustmentPriceQueue()).to(saveOrderGoodsAdjustmentPriceExchange())
                .with(RabbitKeyConstants.SAVE_ORDER_GOODS_ADJUSTMENT_PRICE_ROUTING_KEY);
    }



    /**
     * 监听运单同步履约进度表
     */
    @Bean
    public Queue syncPendingFreight4OrderInfoQueue() {
        return new Queue(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_INFO_QUEUE,
                true, false, false);
    }
    /**
     * 监听运单同步履约进度表
     **/
    @Bean
    public DirectExchange syncPendingFreight4OrderInfoExchange() {
        return new DirectExchange(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_INFO_EXCHANGE);
    }
    /**
     * 监听运单同步履约进度表
     */
    @Bean
    public Binding syncPendingFreight4OrderInfoBind() {
        return BindingBuilder.bind(syncPendingFreight4OrderInfoQueue()).to(syncPendingFreight4OrderInfoExchange())
                .with(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_INFO_ROUTING_KEY);
    }


    /**
     * 监听运单同步履约进度表
     */
    @Bean
    public Queue syncPendingFreight4InternalReportQueue() {
        return new Queue(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_INTERNAL_REPORT_QUEUE,
                true, false, false);
    }
    /**
     * 监听运单同步履约进度表
     **/
    @Bean
    public DirectExchange syncPendingFreight4InternalReportExchange() {
        return new DirectExchange(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_INTERNAL_REPORT_EXCHANGE);
    }
    /**
     * 监听运单同步履约进度表
     */
    @Bean
    public Binding syncPendingFreight4InternalReportBind() {
        return BindingBuilder.bind(syncPendingFreight4InternalReportQueue()).to(syncPendingFreight4InternalReportExchange())
                .with(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_INTERNAL_REPORT_ROUTING_KEY);
    }






    /**
     * 监听货单同步到挂单运费表
     */
    @Bean
    public Queue syncPendingFreight4OrderGoodsQueue() {
        return new Queue(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_GOODS_QUEUE,
                true, false, false);
    }
    /**
     * 监听货单同步到挂单运费表
     **/
    @Bean
    public DirectExchange syncPendingFreight4OrderGoodsExchange() {
        return new DirectExchange(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_GOODS_EXCHANGE);
    }
    /**
     * 监听货单同步到挂单运费表
     */
    @Bean
    public Binding syncPendingFreight4OrderGoodsBind() {
        return BindingBuilder.bind(syncPendingFreight4OrderGoodsQueue()).to(syncPendingFreight4OrderGoodsExchange())
                .with(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_GOODS_ROUTING_KEY);
    }





    /**
     * 监听运单同步到挂单运费表
     */
    @Bean
    public Queue syncPendingFreight4OrderChildQueue() {
        return new Queue(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_CHILD_QUEUE,
                true, false, false);
    }
    /**
     * 监听运单同步到挂单运费表
     **/
    @Bean
    public DirectExchange syncPendingFreight4OrderChildExchange() {
        return new DirectExchange(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_CHILD_EXCHANGE);
    }
    /**
     * 监听运单同步到挂单运费表
     */
    @Bean
    public Binding syncPendingFreight4OrderChildBind() {
        return BindingBuilder.bind(syncPendingFreight4OrderChildQueue()).to(syncPendingFreight4OrderChildExchange())
                .with(RabbitKeyConstants.SYNC_PENDING_FREIGHT_FOR_ORDER_CHILD_ROUTING_KEY);
    }

    /**
     *发送短信通知
     */
    @Bean
    public Queue sendSmsNoticeQueue() {
        return new Queue(RabbitKeyConstants.NOTICE_SEND_SMS_QUEUE,
                true, false, false);
    }
    /**
     * 发送短信通知
     **/
    @Bean
    public DirectExchange sendSmsNoticeExchange() {
        return new DirectExchange(RabbitKeyConstants.NOTICE_SEND_SMS_QUEUE_EXCHANGE);
    }
    /**
     *发送短信通知
     */
    @Bean
    public Binding sendSmsNoticeBind() {
        return BindingBuilder.bind(sendSmsNoticeQueue()).to(sendSmsNoticeExchange())
                .with(RabbitKeyConstants.NOTICE_SEND_SMS_QUEUE_ROUTING_KEY);
    }






}
