package com.clx.performance.feign;

import com.clx.performance.param.feign.OrderAdjustTonnageDownParam;
import com.clx.performance.param.pc.OrderCancelFeignParam;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.param.pc.owner.ThawAccountParam;
import com.clx.performance.param.pc.owner.UpdateStatusParam;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OwnerAccountAllVO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

@FeignClient(name = "clx-performance")
public interface PerformanceFeign {

    /**
     * 通过货单号获取定向车辆
     *
     * @param orderGoodsNo
     * @return
     */
    @Deprecated
    @GetMapping(value = {"clx-performance/feign/orderGoodsDriverTruck/getTrucksByOrderGoodsNo"})
    Result<List<Integer>> getTrucksByOrderGoodsNo(@RequestParam("orderGoodsNo") @NotBlank(message = "货单编号不可为空") String orderGoodsNo);

    @GetMapping(value = {"clx-performance/feign/orderChild/getOrderChildTotalByUserNo"})
    Integer getOrderChildTotalByUserNo(@RequestParam("userNo") Long userNo);

    @GetMapping(value = {"clx-performance/feign/orderGoods/getOrderGoodsListByOrderNo"})
    List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(@RequestParam String orderNo);

    /**
     * 公开货源调用
     *
     * @return
     */
    @GetMapping(value = {"clx-performance/feign/orderGoodsDriverTruck/getPublicTruckList"})
    Result<Set<String>> getPublicTruckList();

    /**
     * 定向货源调用
     *
     * @param orderGoodsNo、
     * @param userNo
     * @return
     */
    @GetMapping(value = {"clx-performance/feign/orderGoodsDriverTruck/getPrivateTruckList"})
    Result<List<String>> getPrivateTruckList(@RequestParam("orderGoodsNo") @NotBlank(message = "货单编号不可为空") String orderGoodsNo,
                                             @RequestParam("userNo") @NotNull(message = "用户编号不可为空") Long userNo);


    @PostMapping(value = {"clx-performance/feign/order/orderCancel"})
    Result<Object> orderCancel(@RequestBody OrderCancelFeignParam param);


    /**
     * 更新货单暂停标志
     * @param orderNo
     * @return
     */
    @GetMapping(value = {"clx-performance/feign/orderGoods/updateOrderGoodsStopFlag"})
    Result<Boolean> updateOrderGoodsStopFlag(@RequestParam("orderNo") String orderNo,@RequestParam("stopFlag") Integer stopFlag);


    @PostMapping(value = {"clx-performance/feign/breakContract/saveSettlementOwnerForTonnageDown"})
    Result saveSettlementOwnerForTonnageDown(@RequestBody OrderAdjustTonnageDownParam param);

    @PostMapping(value = {"clx-performance/feign/owner/ownerAccountFrozen"})
    Result<Object> ownerAccountFrozen(@RequestBody FrozenAccountParam param);

    @PostMapping(value = {"clx-performance/feign/owner/ownerAccountThaw"})
    Result<Object> ownerAccountThaw(@RequestBody ThawAccountParam param);

    @PostMapping(value = {"clx-performance/pc/carrier/settlementOwner/updateStatusByOrderNo"})
    Result<Object> updateStatusByOrderNo(@RequestBody UpdateStatusParam param);

    @GetMapping(value = {"clx-performance/feign/orderChild/selectInTransitOrderChild"})
    Result<Boolean> selectInTransitOrderChild(@RequestParam("orderNo") String orderNo);

    @GetMapping(value = {"clx-performance/feign/owner/accountInfo"})
    Result<OwnerAccountAllVO> accountInfo(@RequestParam Long userNo);
    @GetMapping(value = {"clx-performance/feign/orderGoods/updateSystemAddressId"})
    Result<Boolean> updateSystemAddressId(@RequestParam("ownerAddressId") Integer ownerAddressId,@RequestParam("systemAddressId") Integer systemAddressId);

}
