package com.clx.performance.param.pc.owner;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageOwnerSettlementOwnerDetailParam extends PageParam {

    @NotBlank(message = "结算单编号不能为空")
    @Schema(description = "结算单编号", example = "JS415")
    private String settlementNo;

    @Schema(description="运单编号",example = "201457878")
    private String childNo;

    @Schema(description="订单编号",example = "201457878")
    private String orderNo;

    @Schema(description = "结算子单编号", example = "JS415")
    private String settlementSubNo;

}
