package com.clx.performance.param.app.collect;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Getter
@Setter
@NoArgsConstructor
public class CollectTruckLeaveSaveParam {

    @Schema(description = "请假开始时间")
    @NotBlank(message = "请假开始时间不能为空")
    private String beginTime;
    @Schema(description = "请假结束时间")
    @NotBlank(message = "请假结束时间不能为空")
    private String endTime;
    @Schema(description = "请假原因")
    @NotBlank(message = "请假原因不能为空")
    private String remark;

}
