package com.clx.performance.param.app;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

@Data
public class CheckMobileParam {

    @Schema(description = "手机号", example = "1")
    @NotBlank(message = "手机号")
    private String mobile;

    @Schema(description = "验证码", example = "1")
    @NotBlank(message = "验证码")
    private String captcha;

    @Schema(description = "调用发送短信接口返回的token", example = "1")
    private String token;
}
