package com.clx.performance.enums.linewarn;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum LineWarnInfoEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Status {
        INIT(1, "待处理"),
        RESOLVE(2, "已处理"),
        SUSPEND(3, "暂停预警"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

}
