package com.clx.performance.mapper.export;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.clx.performance.model.export.ExportField;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

public interface ExportFieldMapper extends BaseMapper<ExportField> {


    /**
     * 查询模板下的字段
     *
     * @param templateId 模板id
     * @return List
     */
    @Select("SELECT ef.id,ef.name,ef.code,ef.required,etf.sort,ef.remark,ef.export_function_code exportFunctionCode " +
            "FROM export_template_field etf INNER JOIN export_field ef ON ef.id = etf.export_field_id " +
            "WHERE etf.export_template_id = #{templateId} order by sort")
    List<ExportField> listFieldByTemplate(@Param("templateId") Integer templateId);
}
