package com.clx.performance.vo.feign;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Getter
@Setter
@NoArgsConstructor
public class PlatformServiceFeeConfigFeignVO {

    @Schema(description = "订单报价方式,1:未税,2:含税")
    private Integer orderQuotationType;
    @Schema(description = "结算方式")
    private Integer settlementType;
    @Schema(description = "接单保证金")
    private BigDecimal deposit;
    @Schema(description = "平台服务费费率")
    private BigDecimal serviceFeeRate;
}
