package com.clx.performance.param.pc.breakcontract.carrier;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class PageCarrierBreakContractSettlementOwnerParam extends PageParam {

    @Schema(description="货主编号",example = "201457878")
    private Long ownerUserNo;

    @Schema(description="货主名称")
    private String ownerName;

    @Schema(description="订单编号",example = "201457878")
    private String orderNo;

    @Schema(description="结算单号",example = "201457878")
    private String settlementNo;

    @Schema(description = "违约方类型：1平台 2货主 3车主", example = "1")
    private Integer breakContractPartyType;

    @Schema(description = "状态：10-待对账,20-待货主确认,30-待货主付款,40-待平台确认付款,50-待平台付款,60-待货主确认付款,70-已完结,80-已取消", example = "1")
    private Integer status;

    @Schema(description="开始时间",example = "2012-01-01 00:00:00")
    private String beginTime;

    @Schema(description="结束时间",example = "2012-01-01 00:00:00")
    private String endTime;

    @Schema(description="订单号/结算单号/货主名称/货主编码 复合搜索",example = "")
    private String searchCondition;

}
