package com.clx.performance.job;

import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDao;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.service.breakcontract.BreakContractJobHandlerService;
import com.clx.performance.utils.JobHandlerService;
import com.msl.common.utils.DateUtils;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Component
public class BreakContractSettlementJob {

    @Autowired
    private JobHandlerService jobHandlerService;

    @Autowired
    private BreakContractSettlementDriverDao breakContractSettlementDriverDao;

    @Autowired
    private BreakContractJobHandlerService breakContractJobHandlerService;

    /**
     * 车主违约结算单支付 (每天凌晨2点)
     */
    @XxlJob("breakContractSettlementPay")
    public void breakContractSettlementPay() {
        LocalDateTime beginTime = LocalDateTime.now().minusMonths(1);
        log.info("查询未结算的车主违约结算单,查询开始时间:{}", DateUtils.formatDateTime(beginTime));
        jobHandlerService.handler("违约结算单-支付", ()->{
            List<BreakContractSettlementDriver> list = breakContractSettlementDriverDao.listUnpay(beginTime);
            log.info("车主违约结算单支付，数量:{}", list.size());
            for (BreakContractSettlementDriver item : list) {
                jobHandlerService.subHandler("车主违约结算单-支付", item.getId(), breakContractJobHandlerService::pay);
            }
        });
    }
}
