package com.clx.performance.dto.payment;

import com.fasterxml.jackson.annotation.JsonGetter;
import io.swagger.v3.oas.annotations.media.Schema;

import java.math.BigDecimal;


/**
 *
 * @author 胡宁宁
 * @date 2024年06
 * @description
 */
public class WalletResidueDTO {

	@Schema(description = "余额", example = "11.10")
	private Long residue;

	@Schema(description = "冻结的资金", example = "11.10")
	private Long frozen;

	@Schema(description = "保证金", example = "11.10")
	private Double deposit;

	@Schema(description = "状态0锁定1正常2异常", example = "1")
	private Integer status;

	@Schema(description = "是否设置交易密码0没有1有", example = "1")
	private String pwd;
	
	public Long getResidue() {
		return residue;
	}
	public void setResidue(Long residue) {
		this.residue = residue;
	}
	public Long getFrozen() {
		return frozen;
	}
	public void setFrozen(Long frozen) {
		this.frozen = frozen;
	}
	public Integer getStatus() {
		return status;
	}
	public void setStatus(Integer status) {
		this.status = status;
	}
	public String getPwd() {
		return pwd;
	}
	public void setPwd(String pwd) {
		this.pwd = pwd;
	}
	@JsonGetter(value="frozen")
	public BigDecimal frozenFormat() {
		return BigDecimal.valueOf(new Double(this.frozen)/100);
	}
	@JsonGetter(value="residue")
	public Double residueFormat() {
		return new Double(this.residue)/100;
	}
	@JsonGetter(value="deposit")
	public Double depositFormat() {
		return this.deposit/100;
	}

	public Double getDeposit() {
		return deposit;
	}

	public void setDeposit(Double deposit) {
		this.deposit = deposit;
	}

	@Override
	public String toString() {
		return "WalletDTO [residue=" + residue + ", frozen=" + frozen
				+ ", status=" + status + "]";
	}
	
}
