package com.clx.performance.controller.pc.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.model.OwnerTransferInfo;
import com.clx.performance.param.pc.*;
import com.clx.performance.param.pc.owner.CreteAccountParam;
import com.clx.performance.param.pc.owner.FrozenAccountParam;
import com.clx.performance.service.*;
import com.clx.performance.vo.pc.*;
import com.clx.user.feign.OwnerInfoFeign;
import com.clx.user.param.pc.owner.UpdateOwnerBindCardFeignParam;
import com.clx.user.vo.pc.owner.OwnerBindCardVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping("/pc/owner")
@Validated
@AllArgsConstructor
@Api(tags = "PC-货主资金管理")
public class OwnerAccountController {

    private final OwnerAccountService ownerAccountService;

    private final OwnerTopUpService ownerTopUpService;

    private final OwnerCaseOutService ownerCaseOutService;

    private final OwnerRunningWaterRecordService ownerRunningWaterRecordService;

    private final OwnerBindCardRecordService ownerBindCardRecordService;


    @ApiOperation(value = "账户信息", notes = "<br>By:胡宇帆")
    @GetMapping("/accountInfo")
    @UnitCovert(param = false)
    public Result<OwnerAccountAllVO> accountInfo() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        OwnerAccountAllVO result = ownerAccountService.accountInfo(loginUserInfo.getCompanyNo());
        return Result.ok(result);
    }

    @ApiOperation(value = "货主充值记录列表", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerTopUpPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerTopUpVO>> ownerTopUpPageList(@RequestBody PageOwnerTopUpListParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getCompanyNo());
        IPage<OwnerTopUpVO> page = ownerTopUpService.ownerTopUpPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "货主提现记录列表", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerCaseOutPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerCaseOutVO>> ownerCaseOutPageList(@RequestBody PageOwnerCaseOutListParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setUserNo(loginUserInfo.getCompanyNo());
        IPage<OwnerCaseOutVO> page = ownerCaseOutService.ownerCaseOutPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "账户充值", notes = "<br>By:胡宇帆")
    @PostMapping("/accountTopUp")
    @UnitCovert
    public Result<Long> accountTopUp(@RequestBody OwnerTopUpParam param) {

        Long id = ownerAccountService.accountTopUp(param);
        return Result.ok(id);
    }

    @ApiOperation(value = "账户提现", notes = "<br>By:胡宇帆")
    @PostMapping("/accountCaseOut")
    @UnitCovert
    public Result<Long> accountCaseOut(@RequestBody OwnerCaseOutParam param) {
        Long id = ownerAccountService.accountCaseOut(param);
        return Result.ok(id);
    }

    @ApiOperation(value = "货主付款确认", notes = "<br>By:胡宇帆")
    @GetMapping("/accountBalanceConfirm")
    public Result<Object> accountBalanceConfirm(@RequestParam @NotNull(message = "编号不能为空") Integer id) {
        ownerAccountService.accountBalanceConfirm(id);
        return Result.ok();
    }

    @ApiOperation(value = "货主账户流水列表", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerAccountRunningWaterPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> ownerAccountRunningWaterPageList(@RequestBody PageOwnerAccountRunningWaterParam param) {
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerRunningWaterRecordService.ownerAccountRunningWaterPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "货主账户流水列表下载")
    @PostMapping("/exportOwnerAccountRunningWaterPageList")
    public void exportOwnerAccountRunningWaterPageList(@RequestBody @Validated PageOwnerAccountRunningWaterParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = ownerRunningWaterRecordService.exportOwnerAccountRunningWaterPageList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @ApiOperation(value = "对公转账信息", notes = "<br>By:胡宇帆")
    @GetMapping("/transferPublic")
    public Result<OwnerTransferInfo> transferPublic() {
        return Result.ok(ownerAccountService.transferPublic());
    }

    @ApiOperation(value = "获取货主信息绑卡信息", notes = "<br>By:胡宇帆")
    @GetMapping("/getOwnerBindCard")
    public Result<OwnerBindCardVO> getOwnerBindCard() {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        return Result.ok(ownerAccountService.getOwnerBindCard(loginUserInfo.getCompanyNo()));
    }

    @ApiOperation(value = "绑定货主银行卡")
    @PostMapping({"/bindOwnerBindCard"})
    Result<Object> bindOwnerBindCard(@RequestBody OwnerBindCardParam param) {
        ownerAccountService.bindOwnerBindCard(param);
        return Result.ok();
    }

    @ApiOperation(value = "解绑货主银行卡")
    @PostMapping({"/unBindOwnerBindCard"})
    Result<Object> unBindOwnerBindCard(@RequestBody OwnerBindCardParam param) {
        ownerAccountService.unBindOwnerBindCard(param);
        return Result.ok();
    }

    @ApiOperation(value = "货主绑卡记录列表", notes = "<br>By:胡宇帆")
    @PostMapping("/ownerBindCardPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerBindCardRecordVO>> ownerBindCardPageList(@RequestBody PageOwnerBindCardRecordListParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getUserNo());
        IPage<OwnerBindCardRecordVO> page = ownerBindCardRecordService.ownerBindCardPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "创建账户", notes = "<br>By:胡宇帆")
    @PostMapping("/createAccount")
    public Result<Object> createAccount(@RequestBody CreteAccountParam param) {
        ownerAccountService.createAccount(param);
        return Result.ok();
    }

    @ApiOperation(value = "APP货主流水", notes = "<br>By:胡宇帆")
    @PostMapping("/prepaidFreightOwnerAccountPageList")
    @UnitCovert(param = false)
    public Result<PageData<OwnerAccountRunningWaterRecordVO>> prepaidFreightOwnerAccountPageList(@RequestBody PageAppPrepaidFreightAccountParam param) {
        param.setUserNo(TokenUtil.getLoginUserInfo().getUserNo());
        IPage<OwnerAccountRunningWaterRecordVO> page = ownerAccountService.prepaidFreightOwnerAccountPageList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }
}
