package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public enum AppEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum UniqueIdentifier {

        SMART_WEIGHT(1, "场站-smart-weight"),
        PURCHASE_MANAGE(2, "供应链-purchase-manage"),

        ;

        private final Integer code;
        private final String name;

        public static Optional<UniqueIdentifier> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(UniqueIdentifier::getName).orElse(null);
        }
    }


}
