package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.collect.CollectLineReportEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 道路拥堵情况
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@Schema(description = "道路拥堵情况")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTrafficCongestionVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "用户编号", example = "")
    private Long userNo;
    @Schema(description = "用户姓名", example = "")
    private String name;
    @Schema(description = "手机号码", example = "")
    private String mobile;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
    @Schema(description = "省", example = "")
    private String province;
    @Schema(description = "市", example = "")
    private String city;
    @Schema(description = "区县", example = "")
    private String county;
    @Schema(description = "乡镇", example = "")
    private String town;
    @Schema(description = "街道", example = "")
    private String street;
    @Schema(description = "详细地址", example = "")
    private String address;
    @Schema(description = "经度", example = "")
    private BigDecimal longitude;
    @Schema(description = "纬度", example = "")
    private BigDecimal latitude;
    @Schema(description = "预计拥堵时长", example = "")
    private BigDecimal jamTime;
    @Schema(description = "现场照片", example = "", hidden = true)
    private String jamImage;
    @Schema(description = "现场照片", example = "")
    private List<String> jamImageList;
    public List<String> getJamImageList() {
        return StringUtils.isEmpty(jamImage)? new ArrayList<>() : JSON.parseArray(jamImage, String.class);
    }

    @Schema(description = "上报时间", example = "")
    private String reportTime;
    @Schema(description = "审核状态：0待审核 1已审核", example = "")
    private Integer auditStatus;
    @Schema(description = "审核状态：0待审核 1已审核", example = "")
    private String auditStatusMsg;
    public String getAuditStatusMsg() {
        return CollectLineReportEnum.AuditStatus.getByCode(auditStatus).get().getMsg();
    }

    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}