package com.clx.performance.service.impl;

import com.clx.performance.dao.DictionaryDao;
import com.clx.performance.model.Dictionary;
import com.clx.performance.service.DictionaryService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * @author kavin
 * Date 2024-01-24
 * Time 13:34
 */
@Service
@AllArgsConstructor
public class DictionaryServiceImpl implements DictionaryService {

    private final DictionaryDao dictionaryDao;

    @Override
    public String getOneByKey(String key) {
        Dictionary dictionary = dictionaryDao.getOneByField(Dictionary::getDictionaryName, key).get();
        return dictionary.getDictionaryValue();
    }
}
