package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 货主运单计费明细
* @Date: 2023/10/11 17:46:48
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class SettlementOwnerDetail implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long ownerUserNo;                       //货主用户编号
    private String ownerName;                       //货主名称
    private Integer settlementWay;                  //结算方式  1装车净重 2卸车净重
    private String settlementNo;                    //结算单号
    private String settlementSubNo;                 //结算子单号
    private String childNo;                         //运单编号
    private String orderGoodsNo;                    //货单编号
    private String orderNo;                         //订单编号
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private Integer goodsId;                        //货物id
    private String goodsName;                       //货物名称
    private BigDecimal freightPrice;                //平台运费单价（分）
    private BigDecimal weight;                      //实际净重（吨）
    private BigDecimal freight;                     //实际运费（分）
    private BigDecimal lossPrice;                   //损耗单价（分）
    private BigDecimal lossWeight;                  //货损吨数（吨）
    private BigDecimal lossFreight;                 //货损金额（分）
    private BigDecimal prepayFreight;               //预付运费金额（分）
    private BigDecimal settlementFreight;           //结算金额（分）
    private BigDecimal loanFreight;                 //借款抵扣金额（分）
    private BigDecimal invoiceFreight;              //开票金额（分）
    private Integer invoiceType;                    //开票标识：1网运单 2普通单
    private BigDecimal invoiceServiceFee;           //开票服务费（分）
    private BigDecimal invoiceServiceFeeRate;       //开票服务率
    private Integer finalPaymentStatus;             //尾款状态 0-否,1-是,2-无需支付
    private Integer invoiceStatus;                  //开票状态 0-否,1-是,2-无需开票
    private Integer invoicingCompanyId;  //开票公司id
    private String invoicingCompanyShorterName; //开票公司简称
    private String invoicingCompanyGroupCode;  //开票公司统一社会信用代码
    private Integer reportFlag;  //是否上报 0-否;1-是
    private Integer status;                         //状态
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
