package com.clx.performance.model.settle;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("network_driver_running_water_record")
@Builder
public class NetworkDriverRunningWaterRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("running_water_no")
    @ApiModelProperty("流水号")
    private Long runningWaterNo;

    @TableField("driver_user_no")
    @ApiModelProperty("司机编码")
    private Long driverUserNo;

    @TableField("driver_user_name")
    @ApiModelProperty("司机名称")
    private String driverUserName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("running_water_type")
    @ApiModelProperty("流水类型 10：运单结算 20：提现冻结 30：提现成功")
    private Integer runningWaterType;

    @TableField("running_water_type_msg")
    @ApiModelProperty("流水类型简介")
    private String runningWaterTypeMsg;

    @TableField("frozen_flag")
    @ApiModelProperty("冻结标记：如果是1代表当前冻结流水已经提现成功")
    private Integer frozenFlag;


    @TableField("fund_type")
    @ApiModelProperty("资金类型 10：收入 20：冻结 30：支出")
    private Integer fundType;

    @TableField("fund_type_msg")
    @ApiModelProperty("资金类型简介")
    private String fundTypeMsg;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("order_goods_no")
    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    @TableField("alteration_balance")
    @ApiModelProperty("变动金额")
    private BigDecimal alterationBalance;

    @TableField("frozen_balance")
    @ApiModelProperty("冻结金额")
    private BigDecimal frozenBalance;

    @TableField("usable_balance")
    @ApiModelProperty("可用余额")
    private BigDecimal usableBalance;

    @TableField("account_balance")
    @ApiModelProperty("账户余额")
    private BigDecimal accountBalance;

    @TableField("take_out_balance")
    @ApiModelProperty("扣除金额")
    private BigDecimal takeOutBalance;

    @TableField("create_by")
    @ApiModelProperty("操作人")
    private String createBy;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
