package com.clx.performance.vo.app.breakcontract;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class DriverBreakContractDriverRecordVO {

    @ApiModelProperty("id")
    private Integer id;

    @ApiModelProperty("触发类型：1系统触发 2手动触发")
    private Integer triggerType;

    @ApiModelProperty("违约方类型：1平台 2货主 3司机")
    private Integer breakContractPartyType;

    @ApiModelProperty("违约运单")
    private String childNo;

    @ApiModelProperty("车牌号")
    private String truckNo;

    @ApiModelProperty("车主用户编号")
    private Long truckOwnUserNo;

    @ApiModelProperty("车主名称")
    private String truckOwnName;

    @ApiModelProperty("司机用户编号")
    private Long driverUserNo;

    @ApiModelProperty("司机名称")
    private String driverName;

    @ApiModelProperty("违约金")
    @MoneyOutConvert
    private BigDecimal figure;

    @ApiModelProperty("接单时间限制（小时）")
    private BigDecimal timeLimit;

    @ApiModelProperty("接单限制时间")
    private String limitTime;

    @ApiModelProperty("结算单编号")
    private String settlementNo;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private String createTime;

}
