/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.nist.NISTObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x9.X9IntegerConverter;
import cn.com.infosec.crypto.BasicAgreement;
import cn.com.infosec.crypto.DerivationFunction;
import cn.com.infosec.crypto.agreement.ECDHBasicAgreement;
import cn.com.infosec.crypto.agreement.ECDHCBasicAgreement;
import cn.com.infosec.crypto.agreement.kdf.DHKDFParameters;
import cn.com.infosec.crypto.agreement.kdf.ECDHKEKGenerator;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.params.AsymmetricKeyParameter;
import cn.com.infosec.crypto.params.ECPrivateKeyParameters;
import cn.com.infosec.jce.interfaces.ECPrivateKey;
import cn.com.infosec.jce.interfaces.ECPublicKey;
import cn.com.infosec.jce.provider.ECUtil;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class JCEECDHKeyAgreement
extends KeyAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private static final Hashtable algorithms = new Hashtable();
    private BigInteger result;
    private ECPrivateKeyParameters privKey;
    private BasicAgreement agreement;
    private DerivationFunction kdf;

    static {
        Integer i128 = new Integer(128);
        Integer i192 = new Integer(192);
        Integer i256 = new Integer(256);
        algorithms.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), i128);
        algorithms.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), i192);
        algorithms.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), i256);
        algorithms.put(NISTObjectIdentifiers.id_aes128_wrap.getId(), i128);
        algorithms.put(NISTObjectIdentifiers.id_aes192_wrap.getId(), i192);
        algorithms.put(NISTObjectIdentifiers.id_aes256_wrap.getId(), i256);
        algorithms.put(PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId(), i192);
    }

    private byte[] bigIntToBytes(BigInteger r) {
        return converter.integerToBytes(r, converter.getByteLength(this.privKey.getParameters().getG().getX()));
    }

    protected JCEECDHKeyAgreement(BasicAgreement agreement) {
        this.agreement = agreement;
    }

    protected JCEECDHKeyAgreement(BasicAgreement agreement, DerivationFunction kdf) {
        this.agreement = agreement;
        this.kdf = kdf;
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("EC Diffie-Hellman not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException("EC Diffie-Hellman can only be between two parties.");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("EC Key Agreement doPhase requires ECPublicKey");
        }
        AsymmetricKeyParameter pubKey = ECUtil.generatePublicKeyParameter((PublicKey)key);
        this.result = this.agreement.calculateAgreement(pubKey);
        return null;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.bigIntToBytes(this.result);
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] secret = this.bigIntToBytes(this.result);
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException("ECKeyAgreement - buffer too short");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    protected SecretKey engineGenerateSecret(String algorithm) throws NoSuchAlgorithmException {
        if (this.kdf != null) {
            if (!algorithms.containsKey(algorithm)) {
                throw new NoSuchAlgorithmException("unknown algorithm encountered: " + algorithm);
            }
            int keySize = (Integer)algorithms.get(algorithm);
            DHKDFParameters params = new DHKDFParameters(new DERObjectIdentifier(algorithm), keySize, this.bigIntToBytes(this.result));
            byte[] keyBytes = new byte[keySize / 8];
            this.kdf.init(params);
            this.kdf.generateBytes(keyBytes, 0, keyBytes.length);
            return new SecretKeySpec(keyBytes, algorithm);
        }
        return new SecretKeySpec(this.bigIntToBytes(this.result), algorithm);
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey for initialisation");
        }
        this.privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey");
        }
        this.privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    public static class DH
    extends JCEECDHKeyAgreement {
        public DH() {
            super(new ECDHBasicAgreement());
        }
    }

    public static class DHC
    extends JCEECDHKeyAgreement {
        public DHC() {
            super(new ECDHCBasicAgreement());
        }
    }

    public static class DHwithSHA1KDF
    extends JCEECDHKeyAgreement {
        public DHwithSHA1KDF() {
            super(new ECDHBasicAgreement(), new ECDHKEKGenerator(new SHA1Digest()));
        }
    }
}

