/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.der.util;

import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class ConsoleLogger {
    private static Date now;
    private static SimpleDateFormat format;
    public static boolean isPrintST;
    public static boolean isDebug;
    public static boolean isSave;
    private static int projectID;

    static {
        isPrintST = true;
        isDebug = true;
        isSave = false;
        projectID = 0;
        now = new Date();
        format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static void logException(Throwable e, String info) {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println(info);
        System.out.println("An exception catched: " + e.toString());
        if (isPrintST) {
            System.out.println("Full stacktrace as below:");
            e.printStackTrace(System.out);
            System.out.flush();
        }
        System.out.println("-----------------------------------------------------------");
    }

    public static void logException(Throwable e) {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        System.out.println("An Exception catched:" + e.toString());
        if (isPrintST) {
            System.out.println("Full stacktrace as below:");
            e.printStackTrace(System.out);
            System.out.flush();
        }
        System.out.println("----------------------------------------------------------");
    }

    public static void logBinary(String title, byte[] bs) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        if (bs == null) {
            System.out.println(String.valueOf(title) + "(0):\nnull\n");
        } else {
            System.out.println(String.valueOf(title) + "(" + bs.length + "):");
            int i = 0;
            int length = bs.length;
            while (i < length) {
                int x = bs[i] & 0xFF;
                if (x < 16) {
                    System.out.print("0" + Integer.toString(x, 16) + " ");
                } else {
                    System.out.print(String.valueOf(Integer.toString(x, 16)) + " ");
                }
                if ((i + 1) % 16 == 0) {
                    System.out.print("\n");
                }
                ++i;
            }
            System.out.print("\n");
        }
        System.out.println("----------------------------------------------------------");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveBinary(String file, byte[] bs) {
        block9: {
            if (ConsoleLogger.isSave == false) return;
            ConsoleLogger.now.setTime(System.currentTimeMillis());
            time = ConsoleLogger.format.format(ConsoleLogger.now);
            System.out.println("---------------NetSign(" + time + ")----------------");
            System.out.println("Binary stream saved to file:" + file);
            out = null;
            try {
                try {
                    out = new FileOutputStream(file);
                    out.write(bs);
                    out.flush();
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                try {
                    if (out == null) throw var6_5;
                    out.close();
                    throw var6_5;
                }
                catch (Exception var7_8) {
                    // empty catch block
                }
                throw var6_5;
            }
            {
                var5_7 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 117->128)] { 
lbl28:
            // 1 sources

            if (out != null) {
                out.close();
            }
            break block9;
lbl31:
            // 1 sources

            catch (Exception var7_9) {
                // empty catch block
            }
        }
        System.out.println("----------------------------------------------------------");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveReaded(String file, byte[] content, byte[] length, byte flag) {
        block9: {
            if (ConsoleLogger.isSave == false) return;
            ConsoleLogger.now.setTime(System.currentTimeMillis());
            time = ConsoleLogger.format.format(ConsoleLogger.now);
            System.out.println("---------------NetSign(" + time + ")----------------");
            System.out.println("Binary readed stream saved to file:" + file);
            out = null;
            try {
                try {
                    out = new FileOutputStream(file);
                    tmp = new byte[1 + length.length];
                    tmp[0] = flag;
                    System.arraycopy(length, 0, tmp, 1, length.length);
                    out.write(tmp);
                    out.write(content);
                    out.flush();
                }
                catch (Exception e) {
                    ConsoleLogger.logException(e);
                }
            }
            catch (Throwable var8_8) {
                var7_9 = null;
                try {
                    if (out == null) throw var8_8;
                    out.close();
                    throw var8_8;
                }
                catch (Exception var9_11) {
                    // empty catch block
                }
                throw var8_8;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 153->166)] { 
lbl32:
            // 1 sources

            if (out != null) {
                out.close();
            }
            break block9;
lbl35:
            // 1 sources

            catch (Exception var9_12) {
                // empty catch block
            }
        }
        System.out.println("----------------------------------------------------------");
    }

    public static void logStringForce(String msg) {
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    public static void logString(byte[] msg) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(new String(msg)).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    public static void logString(String msg) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        StringBuffer buf = new StringBuffer();
        buf.append("---------------NetSign(").append(time).append(")----------------\n");
        buf.append(msg).append("\n");
        buf.append("----------------------------------------------------------\n");
        System.out.print(buf.toString());
    }

    public static void logString(String msg, int pid) {
        if (!isDebug) {
            return;
        }
        if (pid == projectID || projectID < 0) {
            now.setTime(System.currentTimeMillis());
            String time = format.format(now);
            System.out.println("---------------NetSign(" + time + ")----------------");
            System.out.println(msg);
            System.out.println("----------------------------------------------------------");
        }
    }

    public static void logArray(Object[] objs) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int i = 0;
        int length = objs.length;
        while (i < length) {
            buf.append(" \"").append(objs[i].toString()).append("\"");
            ++i;
        }
        buf.append("]");
        System.out.println(buf.toString());
        System.out.println("----------------------------------------------------------");
    }

    public static void logMap(Map m) {
        if (!isDebug) {
            return;
        }
        now.setTime(System.currentTimeMillis());
        String time = format.format(now);
        System.out.println("---------------NetSign(" + time + ")----------------");
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator keys = m.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            buf.append(" \"").append(key.toString()).append("=").append(m.get(key).toString()).append("\"");
        }
        buf.append("]");
        System.out.println(buf.toString());
        System.out.println("----------------------------------------------------------");
    }
}

