package com.clx.performance.sqlProvider.breakcontract;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractOwnerRecordParam;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractOwnerRecordVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class BreakContractOwnerRecordSqlProvider {

    public String pageByParam(@Param("page") Page<BreakContractOwnerRecordVO> page, @Param("param") PageBreakContractOwnerRecordParam param) {
        return new SQL(){{

            SELECT(" id, trigger_type, break_contract_party_type, break_no, " +
                    " order_no, owner_user_no, owner_name, figure, " +
                    " settlement_no, " +
                    " remark,confirm_status,reject_reason " +
                    " create_by, create_name, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("break_contract_owner_record");

            if (StringUtils.isNotBlank(param.getOrderNo())) {WHERE("order_no = #{param.orderNo}");}
            if (Objects.nonNull(param.getTriggerType())) {WHERE("trigger_type = #{param.triggerType}");}
            if (Objects.nonNull(param.getBreakContractPartyType())) {WHERE("break_contract_party_type = #{param.breakContractPartyType}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
