package com.clx.performance.service.impl.collect;

import com.clx.performance.dao.collect.CollectTruckDao;
import com.clx.performance.enums.integral.IntegralRecordEnum;
import com.clx.performance.model.collect.CollectTruck;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.service.IntegralRecordService;
import com.clx.performance.service.collect.CollectTruckService;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.struct.collect.CollectTruckStruct;
import com.clx.performance.vo.app.collect.AppCollectTruckVO;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

@Slf4j
@Service
public class CollectTruckServiceImpl implements CollectTruckService {

    @Autowired
    private CollectTruckDao collectTruckDao;

    @Autowired
    private CollectTruckStruct collectTruckStruct;
    @Autowired
    private IntegralRecordService integralRecordService;
    @Autowired
    private IntegralRuleService integralRuleService;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateUnloadType(CollectTruckUnloadTypeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        boolean flag;

        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
            flag = true;
        }
        else {
            flag = !Objects.equals(truck.getUnloadType(), param.getUnloadType());
        }

        truck.setUnloadType(param.getUnloadType());
        collectTruckDao.update(truck);


        if (!flag) {return;}
        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();

        // 报存积分
        integralRecordService.addDriverReportRecord(ruleInfo, truck.getTruckNo(), IntegralRecordEnum.Type.REPORT_TRUCK_INFO.getValue(),
                ruleInfo.getDriverReportRule().getIntegralTruck(), IntegralRecordEnum.Type.REPORT_TRUCK_INFO.getMsg());
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateAutoLoanStatus(CollectAutoLoanStatusUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        boolean flag;

        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
            flag = true;
        }
        else {
            flag = !(Objects.equals(truck.getAutoLoanStatus(), param.getAutoLoanStatus())&&Objects.equals(truck.getAutoLoanMonth(), param.getAutoLoanMonth()));
        }

        truck.setAutoLoanStatus(param.getAutoLoanStatus());
        truck.setAutoLoanMonth(param.getAutoLoanMonth());
        collectTruckDao.update(truck);

        if (!flag) {return;}
        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();

        // 报存积分
        integralRecordService.addDriverReportRecord(ruleInfo, truck.getTruckNo(), IntegralRecordEnum.Type.REPORT_TRUCK_INFO.getValue(),
                ruleInfo.getDriverReportRule().getIntegralTruck(), IntegralRecordEnum.Type.REPORT_TRUCK_INFO.getMsg());

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateParkAddress(CollectTruckReportParkAddressUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        boolean flag;

        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
            flag = true;
        }
        else {
            flag = !Objects.equals(truck.getParkAddress(), param.getParkAddress());
        }

        truck.setParkAddress(param.getParkAddress());
        collectTruckDao.update(truck);

        if (!flag) {return;}
        // 查找规则
        AppIntegralRuleVO ruleInfo = integralRuleService.getRuleInfo();

        // 报存积分
        integralRecordService.addDriverReportRecord(ruleInfo, truck.getTruckNo(), IntegralRecordEnum.Type.REPORT_TRUCK_INFO.getValue(),
                ruleInfo.getDriverReportRule().getIntegralTruck(), IntegralRecordEnum.Type.REPORT_TRUCK_INFO.getMsg());

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateOverTonnageType(CollectTruckReportOverTonnageTypeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setOverTonnageType(param.getOverTonnageType());
        collectTruckDao.update(truck);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateDistanceUsualPlaceMax(CollectTruckReportDistanceUsualPlaceMaxUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setDistanceUsualPlaceMax(param.getDistanceUsualPlaceMax());
        collectTruckDao.update(truck);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateDistanceLineMax(CollectTruckReportDistanceLineMaxUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setDistanceLineMax(param.getDistanceLineMax());
        collectTruckDao.update(truck);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateDistanceSendAddressMax(CollectTruckReportDistanceSendAddressMaxUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setDistanceSendAddressMax(param.getDistanceSendAddressMax());
        collectTruckDao.update(truck);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateGoodsType(CollectTruckReportGoodsTypeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, param.getTruckNo()).orNull();
        if (truck == null) {
            truck.setUserNo(userNo);
            truck.setName(loginUserInfo.getUserName());
            truck.setMobile(loginUserInfo.getUserMobile());
            truck.setTruckNo(param.getTruckNo());
            collectTruckDao.saveEntity(truck);
        }

        truck.setGoodsType(param.getGoodsType());
        collectTruckDao.update(truck);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public AppCollectTruckVO getReportInfo(String truckNo) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        Long userNo = loginUserInfo.getUserNo();
        CollectTruck truck = collectTruckDao.getByUserNoAndTruckNo(userNo, truckNo).orNull();

        return collectTruckStruct.convertAppCollectTruckVO(truck);

    }

}
