package com.clx.performance.service.impl.child;

import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.enums.OrderChildLogEnum;
import com.clx.performance.enums.UserTypeEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.IntegralMqService;
import com.clx.performance.service.OrderChildMqService;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import com.clx.performance.service.child.OrderChildPostService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class OrderChildPostServiceImpl implements OrderChildPostService {

    @Autowired
    private IntegralMqService integralMqService;

    @Autowired
    private OrderChildMqService orderChildMqService;

    @Autowired
    private BreakContractDriverRecordService breakContractDriverRecordService;

    @Override
    public void orderChildDriverConfirm(OrderChild orderChild) {

        orderChildFinish(orderChild.getChildNo());

        // 发送mq 司机确认收货
        orderChildMqService.orderChildDriverConfirm(orderChild.getChildNo());
    }



    /**
     * 司机取消
     */
    @Override
    public void orderChildCancelByDriver(OrderChild orderChild, Integer opUserType, Long opUserNo, String opUserName){
        orderChildFinish(orderChild.getChildNo());

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(orderChild.getChildNo(), orderChild.getStatus(), opUserType, opUserNo, opUserName);
    }

    /**
     * 承运取消
     */
    @Override
    public void orderChildCancelByCarrier(OrderChild orderChild, Integer opUserType, Long opUserNo, String opUserName) {
        orderChildFinish(orderChild.getChildNo());

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(orderChild.getChildNo(), orderChild.getStatus(), opUserType, opUserNo, opUserName);

    }

    /**
     * 到达货源地超时取消
     */
    @Override
    public void arriveSendAddressTimeoutCancel(OrderChild orderChild){

        // 保存违约记录
        breakContractDriverRecordService.saveDriverRecordOfArriveSendAddressTimeout(orderChild, 0L, "系统");

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(orderChild.getChildNo(), OrderChildLogEnum.Type.PLATFORM_CANCEL.getCode(), UserTypeEnum.SYSTEM.getCode(), 0L, "系统");

    }

    @Override
    public void orderCancel(String childNo) {
        orderChildFinish(childNo);

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(childNo, OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), UserTypeEnum.SYSTEM.getCode(), 0L, "系统");

    }

    @Override
    public void orderGoodsCancel(String childNo) {
        orderChildFinish(childNo);

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(childNo, OrderChildEnum.Status.PLATFORM_CANCEL.getCode(), UserTypeEnum.SYSTEM.getCode(), 0L, "系统");

    }

    @Override
    public void orderChildCancelByArtificial(String childNo) {
        orderChildFinish(childNo);

        // 发送mq （运单取消）
        orderChildMqService.orderChildCancel(childNo, OrderChildEnum.Status.ARTIFICIAL_CANCEL.getCode(), UserTypeEnum.CARRIER.getCode(), 0L, "系统");

    }

    /**
     * 运单结束
     */
    @Override
    public void orderChildFinish(String childNo) {
        // 运单结束 统计积分
        integralMqService.orderChildFinish(childNo);
    }

}
