package com.clx.performance.service.impl;

import com.clx.order.enums.OrderEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.LastTruckService;
import com.clx.user.enums.SyncPlatformEnum;
import com.msl.common.exception.ServiceSystemException;
import groovy.util.logging.Slf4j;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @ClassName LastTruckServiceImpl
 * @Description
 * @Author kavin
 * @Date 2023/11/9 13:13
 * @Version 1.0
 */
@Service
@Slf4j
@AllArgsConstructor
public class LastTruckServiceImpl implements LastTruckService {

    private final OrderFeign orderFeign;
    private final OrderChildDao orderChildDao;
    private final OrderGoodsDao orderGoodsDao;
    /**
     * @Author kavin
     * @Description 判断最后一车的逻辑
     * @Param [orderNo]
     * @return
     **/
    @Override
    public OrderChild getLastTruckChild(String orderNo) {
        //判断订单是否已经完结
        FeignOrderVO orderInfo = orderFeign.getOrderInfoFeign(orderNo);
        if(Objects.isNull(orderInfo)){
            return null;
        }
        if(!Objects.equals(orderInfo.getOrderSource(), SyncPlatformEnum.TRADE_PLATFORM.getCode())){
           return null;
        }
        //已完结直接按照时间顺序查找最后一个运单
        if(Objects.equals(orderInfo.getOrderStatus(), OrderEnum.Status.COMPLETED.getCode()) ||
                Objects.equals(orderInfo.getOrderStatus(), OrderEnum.Status.SUCCESS.getCode())
        ){
            return orderChildDao.findLastTruckChild(orderNo);
        }else{   //未完结，判断所有货单的已拉运的吨数是否等于 订单的拉运吨数-向下浮动量
            BigDecimal alreadyTransprotWeight = orderGoodsDao.getAlreadyTransportWeight(orderNo);
            //查询所有货单的已拉运吨数 + 向下浮动量 >= 订单的承运吨数 (满足此情况查找最后一单)
            if(Objects.nonNull(alreadyTransprotWeight) &&
                    alreadyTransprotWeight.add(new BigDecimal(orderInfo.getDownFloatWeight())).compareTo(orderInfo.getTransportWeight()) >= 0){
                return orderChildDao.findLastTruckChild(orderNo);
            }
        }
        return null;
    }
}
