package com.clx.performance.job;

import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.msl.common.job.JobLog;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class SettlementOwnerMontnJob {

    @Autowired
    SettlementOwnerService settlementOwnerService;

    /**
     * 月结货主结算单状态变更为锁定
     */
    @XxlJob("settlementOwnerMontnInit")
    public void settlementOwnerMontnInit() {
        try {
            //所有月结的待锁定的货主结算单修改状态为锁定
            settlementOwnerService.updateStatusByOrderNo(null,
                    SettlementOwnerEnum.SettlementPeriodType.MONTH.getCode(),
                    SettlementOwnerEnum.Status.TO_BE_LOCKED.getCode(),
                    SettlementOwnerEnum.Status.TO_BE_ACCOUNT.getCode());
        } catch (Exception e) {
            log.warn("月结货主结算单状态变更为锁定，异常原因:{}",e);
            JobLog.error("月结货主结算单状态变更为锁定，异常原因=====================", e);
        }
    }




}
