package com.clx.performance.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.OwnerAccountMapper;
import com.clx.performance.model.OwnerAccount;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.msl.common.dao.BaseDao;

import java.time.LocalDateTime;
import java.util.List;

public interface OwnerAccountDao extends BaseDao<OwnerAccountMapper, OwnerAccount, Integer> {
    IPage<OwnerAccountVO> pageList(PageOwnerAccountListParam param);

    List<OwnerAccount> accountInfo(Long ownerUserNo);

    OwnerAccount getAccountByOwnerUserNoAndAccountType(Long ownerUserNo, Integer accountType);

    Integer updateOwnerAccountForConfirm(OwnerAccount account);

    Integer updateAccountCAS(OwnerAccount account, LocalDateTime now, boolean flag);

    Integer thawAccount(OwnerAccount account, LocalDateTime now);

}
