package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 结算-mq
 * @Date: 2023-10-19 15:10:10
 * @Version: 1.0
 */
public class RabbitKeyOrderChildConstants {

    private static final String PREFIX = "clx-performance.orderChild.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeyOrderChildConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 新增
     */
    public static final String ORDER_CHILD_ADD_QUEUE = PREFIX +"orderChild.add"+QUEUE;
    public static final String ORDER_CHILD_ADD_ROUTING_KEY = PREFIX +"orderChild.add"+QUEUE_ROUTING_KEY;

    /**
     * 司机确认
     */
    public static final String ORDER_CHILD_DRIVER_CONFIRM_QUEUE = PREFIX +"orderChild.driverConfirm"+QUEUE;
    public static final String ORDER_CHILD_DRIVER_CONFIRM_ROUTING_KEY = PREFIX +"orderChild.driverConfirm"+QUEUE_ROUTING_KEY;

    /**
     * 运单完成
     */
    public static final String CHILD_FINISH_QUEUE = PREFIX +"child.finish"+QUEUE;
    public static final String CHILD_FINISH_ROUTING_KEY = PREFIX +"child.finish"+QUEUE_ROUTING_KEY;

    /**
     * 装车
     */
    public static final String ORDER_CHILD_LOAD_QUEUE = PREFIX +"orderChild.load"+QUEUE;
    public static final String ORDER_CHILD_LOAD_ROUTING_KEY = PREFIX +"orderChild.load"+QUEUE_ROUTING_KEY;

    /**
     * 卸车
     */
    public static final String ORDER_CHILD_UNLOAD_QUEUE = PREFIX +"orderChild.unload"+QUEUE;
    public static final String ORDER_CHILD_UNLOAD_ROUTING_KEY = PREFIX +"orderChild.unload"+QUEUE_ROUTING_KEY;

}
