package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.collect.CollectTruckWaitEnum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 线路排队耗时
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@ApiModel(description = "线路排队耗时")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckWaitVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "用户姓名", example = "")
    private String name;
    @ApiModelProperty(value = "手机号码", example = "")
    private String mobile;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @ApiModelProperty(value = "运单编号", example = "")
    private String childNo;
    @ApiModelProperty(value = "地址id", example = "")
    private Integer addressId;
    @ApiModelProperty(value = "详细地址", example = "")
    private String address;
    @ApiModelProperty(value = "上报类型：1 装车类型 2卸车类型", example = "")
    private Integer reportType;

    @ApiModelProperty(value = "上报类型：1 装车类型 2卸车类型", example = "")
    private String reportTypeMsg;
    public String getReportTypeMsg() {
        return CollectTruckWaitEnum.ReportType.getByCode(reportType).get().getMsg();
    }

    @ApiModelProperty(value = "上报类型：1 需要排队 ", example = "")
    private Integer waitType;
    @ApiModelProperty(value = "上报类型：1 需要排队 ", example = "")
    private String waitTypeMsg;
    public String getWaitTypeMsg() {
        return CollectTruckWaitEnum.waitType.getByCode(waitType).get().getMsg();
    }

    @JsonIgnore
    @ApiModelProperty(value = "预计站内等待时长", example = "", hidden = true)
    private BigDecimal stationInTime;
    @JsonIgnore
    @ApiModelProperty(value = "预计站内等待时长图片", example = "", hidden = true)
    private String stationInImage;
    @JsonIgnore
    @ApiModelProperty(value = "预计站外等待时长", example = "", hidden = true)
    private BigDecimal stationOutTime;
    @JsonIgnore
    @ApiModelProperty(value = "预计站外等待时长图片", example = "", hidden = true)
    private String stationOutImage;

    @ApiModelProperty(value = "预计等待时长", example = "")
    private BigDecimal stationTime;
    public BigDecimal getStationTime() {
        return stationInTime;
    }

    @ApiModelProperty(value = "预计等待时长图片", example = "")
    private List<String> stationImageList;
    public List<String> getStationImageList() {
        return StringUtils.isEmpty(stationOutImage)? new ArrayList<>() : JSON.parseArray(stationInImage, String.class);
    }

    @ApiModelProperty(value = "上报时间", example = "")
    private String reportTime;
    @ApiModelProperty(value = "审核状态：0待审核 1已审核", example = "")
    private Integer auditStatus;
    @ApiModelProperty(value = "审核状态：0待审核 1已审核", example = "")
    private String auditStatusMsg;
    public String getAuditStatusMsg() {
        return CollectTruckWaitEnum.AuditStatus.getByCode(auditStatus).get().getMsg();
    }
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}