package com.clx.performance.vo.pc.collect;

import com.alibaba.fastjson.JSON;
import com.clx.performance.enums.collect.CollectLineReportEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 线路信息上报
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@ApiModel(description = "线路信息上报")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectLineReportVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "用户姓名", example = "")
    private String name;
    @ApiModelProperty(value = "手机号码", example = "")
    private String mobile;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @ApiModelProperty(value = "运单编号", example = "")
    private String childNo;
    @ApiModelProperty(value = "货单单编号", example = "")
    private String orderGoodsNo;

    @ApiModelProperty(value = "发货地址id", example = "")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "")
    private String receiveAddress;

    @ApiModelProperty(value = "类型：1 发货地 2 目的地", example = "")
    private Integer type;
    @ApiModelProperty(value = "上报类型（1~4异常上报）：1:无法到达货源地 2:无法装货 3：无法到达目的地  4：装车卸车异常    6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报", example = "")
    private Integer reportType;
    @ApiModelProperty(value = "上报类型（1~4异常上报）：1:无法到达货源地 2:无法装货 3：无法到达目的地  4：装车卸车异常    6：没有接单 7：货源地情况 8:其它上报 9：煤炭质量上报", example = "")
    private String reportTypeMsg;
    public String getReportTypeMsg() {
        return CollectLineReportEnum.ReportType.getByCode(reportType).get().getMsg();
    }

    @ApiModelProperty(value = "拉运状态 1: 正常 2：异常", example = "")
    private Integer reportStatus;
    @ApiModelProperty(value = "拉运状态 1: 正常 2：异常", example = "")
    private String reportStatusMsg;
    public String getReportStatusMsg() {
        return CollectLineReportEnum.ReportStatus.getByCode(reportStatus).get().getMsg();
    }

    @ApiModelProperty(value = "状态描述", example = "")
    private String remark;
    @ApiModelProperty(value = "上报图片", example = "", hidden = true)
    private String image;
    @ApiModelProperty(value = "上报图片")
    private List<String> imageList;
    public List<String> getImageList() {
        return StringUtils.isEmpty(image)? new ArrayList<>() : JSON.parseArray(image, String.class);
    }

    @ApiModelProperty(value = "上报时间", example = "")
    private String reportTime;
    @ApiModelProperty(value = "审核状态：0待审核 1已审核", example = "")
    private Integer auditStatus;
    @ApiModelProperty(value = "审核状态：0待审核 1已审核", example = "")
    private String auditStatusMsg;
    public String getAuditStatusMsg() {
        return CollectLineReportEnum.AuditStatus.getByCode(auditStatus).get().getMsg();
    }

    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}