package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName CarrierPageSettlementOwnerDetailVO
 * @Description
 * @Author kavin
 * @Date 2023/10/16 15:01
 * @Version 1.0
 */
@Getter
@Setter
public class CarrierPageSettlementOwnerDetailVO {

    @ApiModelProperty(value = "计费明细ID")
    private Integer id;                             
    @ApiModelProperty(value = "货主编码")
    private Long ownerUserNo;                       
    @ApiModelProperty(value = "货主姓名")
    private String ownerName;                       
    @ApiModelProperty(value = "订单编号")
    private String orderNo;
    @ApiModelProperty(value = "运单编号")
    private String childNo;                         
    @ApiModelProperty(value = "结算单号")
    private String settlementNo;
    @ApiModelProperty(value = "发货地址id", example = "")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "")
    private String receiveAddress;
    @ApiModelProperty(value = "货物id")
    private Integer goodsId;                        
    @ApiModelProperty(value = "货物名称")
    private String goodsName;                       
    @ApiModelProperty(value = "实际净重（吨）")
    private BigDecimal weight;                      
    @MoneyOutConvert
    @ApiModelProperty(value = "平台运费报价")
    private BigDecimal freightPrice;
    @MoneyOutConvert
    @ApiModelProperty(value = "实际运费金额")
    private BigDecimal freight;
    @ApiModelProperty(value = "货损吨数（吨）")
    private BigDecimal lossWeight;
    @MoneyOutConvert
    @ApiModelProperty(value = "货损单价")
    private BigDecimal lossPrice;
    @MoneyOutConvert
    @ApiModelProperty(value = "货损金额")
    private BigDecimal lossFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "预付运费金额")
    private BigDecimal prepayFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "结算金额")
    private BigDecimal settlementFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "开票金额")
    private BigDecimal invoiceFreight;              
    @ApiModelProperty(value = "开票标识：1网运单 2普通单")
    private Integer invoiceType;

    @ApiModelProperty(value = "创建时间")
    private String createTime;



}
