package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;

/**
 * @ClassName PageTruckListParam
 * @Description
 * @Author kavin
 * @Date 2023/9/19 16:04
 * @Version 1.0
 */
@Getter
@Setter
public class PageTruckListParam extends PageParam {

    @NotNull(message = "需要车数不能为空")
    @ApiModelProperty(value = "需要车辆数量", example = "5")
    private Integer needTruckNum;
    @ApiModelProperty(value = "空重车状态 1:空车 2:运单-空车 3:运单-重车", example = "1")
    private Integer truckUserStatus;
    @ApiModelProperty(value = "车辆等级", example = "A")
    private String truckLevel;
    @ApiModelProperty(value = "距离最大值", example = "20")
    private Integer maxDistance;
    @ApiModelProperty(value = "车牌号", example = "冀F12345")
    private String truckNo;
    @NotNull(message = "订单编号不能为空")
    @ApiModelProperty(value = "订单编号", example = "PT2023091600001")
    private String orderNo;


}
