package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectWaitReportSendAddressSaveParam {

    @ApiModelProperty(value = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "排队状态：1 无需排队 2 场内需要排队 3 厂外需要排队", example = "1")
    @NotNull(message = "排队状态不能为空")
    private Integer waitType;

    @ApiModelProperty(value = "预计站内等待时长", example = "1")
    private BigDecimal stationInTime;
    @ApiModelProperty(value = "预计站内等待时长图片列表")
    private List<String> stationInImageList;

}
