package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildLogEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        CREATED(11, "已接单"),

        PAY(21, "支付成功"),

        GO_TO_SEND(31, "前往货源地"),
        ARRIVE_SEND(32, "到达货源地"),
        GO_TO_RECEIVE(33, "前往目的地"),
        ARRIVE_RECEIVE(34 , "到达目的地"),

        LOAD(41, "装车成功"),
        UNLOAD(42, "收货待确认"),
        RELOAD(43, "修改装货信息"),
        REUNLOAD(44, "修改卸货信息"),
        RELOAD_AND_REUNLOAD(45, "修改装货、卸货信息"),

        DRIVER_CONFIRM(51, "司机确认收货"),

        SETTLEMENT(61, "结算成功"),

        POUND_AUDIT(71, "磅单审核通过"),
        POUND_AUDIT_REJECT(72, "磅单审核驳回"),

        COMPLETE(100, "完成"),

        DRIVER_CANCEL(110, "司机取消"),
        PLATFORM_CANCEL(111, "承运取消"),
        OWNER_CANCEL(112, "货主取消"),

        ;

        private final int code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum CreateType {
        OWNER(1, "货主"),
        PLATFORM(2, "承运"),
        DRIVER(3, "司机"),

        ;

        private final int code;
        private final String msg;

        public static Optional<CreateType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
