package com.clx.performance.service.impl.settle;


import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.settle.NetworkCaseOutRecordDao;
import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.dto.PayStatusNotifyDTO;
import com.clx.performance.enums.NetworkDriverAccountEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.payment.PayPlatformFeeParam;
import com.clx.performance.service.PaymentService;
import com.clx.performance.service.settle.NetworkDriverRunningWaterRecordService;
import com.clx.performance.service.settle.OrderChildSyncTransportRecordService;
import com.clx.performance.service.settle.SettlementDriverDetailService;
import com.clx.performance.service.settle.SettlementDriverService;
import com.clx.performance.struct.settle.SettlementDriverDetailStruct;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Objects;

/**
 * @author kavin
 * Date 2023-12-08
 * Time 11:42
 */
@Service
@Slf4j
@AllArgsConstructor
public class OrderChildSyncTransportRecordServiceImpl implements OrderChildSyncTransportRecordService {

    private final OrderChildSyncTransportRecordDao orderChildSyncTransportRecordDao;

    private final SettlementDriverDetailStruct struct;

    private final NetworkCaseOutRecordDao networkCaseOutRecordDao;

    private final NetworkDriverRunningWaterRecordService networkDriverRunningWaterRecordService;

    private final SettlementDriverDetailService settlementDriverDetailService;

    private final OrderChildDao orderChildDao;

    private final  PaymentService paymentService;
    @Override
    public void addOrderChildSyncTransportRecord(SettlementDriverDetail detail) {
        OrderChildSyncTransportRecord record = struct.convertRecord(detail);
        //0：未同步
        record.setStatus(0);
        orderChildSyncTransportRecordDao.saveEntity(record);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateStatus(PayStatusNotifyDTO payStatusNotifyDTO) {
        String childNo = payStatusNotifyDTO.getChildNo();
        orderChildSyncTransportRecordDao.updateStatus(childNo);
        networkCaseOutRecordDao.updateStatus(payStatusNotifyDTO.getChildNo(),
                NetworkDriverAccountEnum.CaseOutRecordStatus.PAYED.getCode(),
                NetworkDriverAccountEnum.CaseOutRecordStatus.PAYED.getMsg()
        );
        SettlementDriverDetail driverDetail = settlementDriverDetailService.selectOneByChildNo(childNo);
        networkDriverRunningWaterRecordService.generateCaseOutSuccessRunningWaterRecord(driverDetail);

        try{
            //支付平台服务费
            OrderChild orderChild = orderChildDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);
            if (Objects.nonNull(orderChild.getPlatformServiceFee()) &&
                    !Objects.equals(orderChild.getPlatformServiceFee().intValue(), 0)) {
                PayPlatformFeeParam payPlatformFeeParam = PayPlatformFeeParam.builder()
                        .figure(orderChild.getPlatformServiceFee().intValue())
                        .tradeNo(childNo)
                        .build();
                Result result = paymentService.paymentCompletePlatformFee(payPlatformFeeParam);
                log.info("运单完成 第三方回调 {}  ,{} " ,childNo,result);
            }
        }catch (Exception e){
            log.error("支付平台服务费异常 {}",e);
        }
    }
}
