package com.clx.performance.dao.impl.settle;


import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.mapper.settle.OrderChildSyncTransportRecordMapper;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2023-12-08
 * Time 11:42
 */
@Repository
public class OrderChildSyncTransportRecordDaoImpl extends BaseDaoImpl<OrderChildSyncTransportRecordMapper, OrderChildSyncTransportRecord, Integer> implements OrderChildSyncTransportRecordDao {

    @Override
    public List<OrderChildSyncTransportRecord> selectListForJob() {
        return baseMapper.selectList(lQrWrapper()
                .gt(OrderChildSyncTransportRecord::getCreateTime, LocalDateTime.now().minusMonths(3))
                .eq(OrderChildSyncTransportRecord::getStatus, 0)
        );
    }

    @Override
    public void updateStatus(String childNo) {
        update(lUdWrapper().eq(OrderChildSyncTransportRecord::getChildNo, childNo)
                .set(OrderChildSyncTransportRecord::getStatus, 2)
        );
    }

    @Override
    public Optional<OrderChildSyncTransportRecord> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(OrderChildSyncTransportRecord::getChildNo, item)
                )
                .map(super::getOne);
    }
}
