package com.clx.performance.vo.app;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class APPNetworkDriverRunningWaterRecordVO {

    private Integer id;

    @ApiModelProperty("流水号")
    private Long runningWaterNo;

    @ApiModelProperty("司机编码")
    private Long driverUserNo;

    @ApiModelProperty("司机名称")
    private String driverUserName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("流水类型 10：运单结算 20：提现冻结 30：提现成功")
    private Integer runningWaterType;

    @ApiModelProperty("流水类型简介")
    private String runningWaterTypeMsg;

    @ApiModelProperty("资金类型 10：收入 20：冻结 30：支出")
    private Integer fundType;

    @ApiModelProperty("资金类型简介")
    private String fundTypeMsg;

    @ApiModelProperty("")
    private Long relationId;

    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("运单编号")
    private String childNo;

    @ApiModelProperty("变动金额")
    @MoneyOutConvert
    private BigDecimal alterationBalance;

    @ApiModelProperty("冻结金额")
    @MoneyOutConvert
    private BigDecimal frozenBalance;

    @ApiModelProperty("可用余额")
    @MoneyOutConvert
    private BigDecimal usableBalance;

    @ApiModelProperty("账户余额")
    @MoneyOutConvert
    private BigDecimal accountBalance;

    @ApiModelProperty("扣除金额")
    @MoneyOutConvert
    private BigDecimal takeOutBalance;

    @ApiModelProperty("操作人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("修改时间")
    private String modifiedTime;

}
