package com.clx.performance.feign;

import com.clx.performance.vo.pc.broker.TransportParam;
import com.clx.performance.vo.pc.broker.TransportVO;
import com.msl.common.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@FeignClient(name = "broker-service",configuration = PerformanceClientConfiguration.class,url = "${settlement.brokerHost}")
public interface BrokerFeign {

    /**
     * 运单同步
     */
    @RequestMapping(method = RequestMethod.POST, value = "/broker-service/open/transport/saveTransport")
    Result<Object> saveTransport(@RequestBody TransportParam param);

    @RequestMapping(value = "/broker-service/open/transport/getTransportByChildNo", method = RequestMethod.GET)
    Result<TransportVO> getTransportByChildNo(@RequestParam @NotBlank(message = "运单编号不能为空") String orderCode,
                                              @RequestParam @NotNull(message = "userCode不能为空") String userCode);

}
