package com.clx.performance.sqlProvider.collect;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.collect.PageCollectTruckLeaveParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckLeaveParam;
import com.clx.performance.vo.app.collect.CollectTruckLeaveVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class CollectTruckLeaveSqlProvider {

    public String pageLeave(@Param("page") Page<CollectTruckLeaveVO> page, @Param("param") PageCollectTruckLeaveParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, truck_no as truckNo, " +
                    " date_format(begin_time, '%Y-%m-%d %H:%i:%s') as beginTime, " +
                    " date_format(end_time, '%Y-%m-%d %H:%i:%s') as endTime, " +
                    " remark, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_truck_leave ");
            WHERE("user_no = #{param.userNo} ");

            ORDER_BY("create_time desc");
        }}.toString();
    }
    public String carrierPageLeave(@Param("page") Page<CollectTruckLeaveVO> page, @Param("param") CarrierPageCollectTruckLeaveParam param) {
        return new SQL(){{
            SELECT(" id, user_no as userNo, name, mobile, truck_no as truckNo, " +
                    " date_format(begin_time, '%Y-%m-%d %H:%i:%s') as beginTime, " +
                    " date_format(end_time, '%Y-%m-%d %H:%i:%s') as endTime, " +
                    " remark, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );
            FROM("collect_truck_leave ");
            if (StringUtils.isNotBlank(param.getName())) {WHERE("name = #{param.name}");}
            if (StringUtils.isNotBlank(param.getMobile())) {WHERE("mobile = #{param.mobile}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            if (StringUtils.isNotBlank(param.getBeginTime1())) {WHERE("begin_time >= #{param.beginTime1}");}
            if (StringUtils.isNotBlank(param.getEndTime1())) {WHERE("begin_time <= #{param.endTime1}");}

            if (StringUtils.isNotBlank(param.getBeginTime2())) {WHERE("end_time >= #{param.beginTime2}");}
            if (StringUtils.isNotBlank(param.getEndTime2())) {WHERE("end_time <= #{param.endTime2}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
