package com.clx.performance.service.impl.integral;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.integral.IntegralTruckRuleDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.integral.IntegralTruckRule;
import com.clx.performance.param.pc.integral.*;
import com.clx.performance.service.integral.IntegralTruckRuleService;
import com.clx.performance.struct.integral.IntegralTruckRuleStruct;
import com.clx.performance.vo.pc.integral.AppIntegralTruckRuleVO;
import com.msl.common.exception.ServiceSystemException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Slf4j
@Service
public class IntegralTruckRuleServiceImpl implements IntegralTruckRuleService {

    @Autowired
    private IntegralTruckRuleDao integralTruckRuleDao;
    @Autowired
    private IntegralTruckRuleStruct integralTruckRuleStruct;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addRule(IntegralTruckRuleSaveParam param) {

        IntegralTruckRule rule = new IntegralTruckRule();
        rule.setName(param.getName());
        rule.setStatus(param.getStatus());
        rule.setIntegralRatioBegin(param.getIntegralRatioBegin());
        rule.setIntegralRatioEnd(param.getIntegralRatioEnd());
        rule.setIncomeBegin(param.getIncomeBegin());
        rule.setIncomeEnd(param.getIncomeEnd());

        // 范围重叠验证
        List<IntegralTruckRule> list = integralTruckRuleDao.listAllRule();
        if (!list.isEmpty()) {
            if (list.get(0).getIntegralRatioBegin() == null
                    || list.get(0).getIntegralRatioBegin() == 0) {list.get(0).setIntegralRatioBegin(-1);}
            if (list.get(list.size()-1).getIntegralRatioEnd() == null
                    || list.get(list.size()-1).getIntegralRatioEnd() == 100){list.get(list.size()-1).setIntegralRatioEnd(101);}

            if (param.getIntegralRatioBegin() == null) {param.setIntegralRatioEnd(0);}
            if (param.getIntegralRatioEnd() == null){param.setIntegralRatioEnd(100);}

            for (IntegralTruckRule item : list) {
                if (item.getName().equals(param.getName())) {throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_NAME_EXIST);}

                if ((param.getIntegralRatioBegin().compareTo(item.getIntegralRatioBegin()) >= 0)
                        && (param.getIntegralRatioBegin().compareTo(item.getIntegralRatioEnd()) < 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }
                if ((param.getIntegralRatioEnd().compareTo(item.getIntegralRatioBegin()) > 0)
                        && (param.getIntegralRatioEnd().compareTo(item.getIntegralRatioEnd()) <= 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }

                if ((item.getIntegralRatioBegin().compareTo(param.getIntegralRatioBegin()) >= 0)
                        && (item.getIntegralRatioBegin().compareTo(param.getIntegralRatioEnd()) < 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }
                if ((item.getIntegralRatioEnd().compareTo(param.getIntegralRatioBegin()) > 0)
                        && (item.getIntegralRatioEnd().compareTo(param.getIntegralRatioEnd()) <= 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }
            }
        }

        integralTruckRuleDao.saveEntity(rule);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRule(IntegralTruckRuleUpdateParam param) {
        IntegralTruckRule rule = integralTruckRuleDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        rule.setName(param.getName());
        rule.setStatus(param.getStatus());
        rule.setIntegralRatioBegin(param.getIntegralRatioBegin());
        rule.setIntegralRatioEnd(param.getIntegralRatioEnd());
        rule.setIncomeBegin(param.getIncomeBegin());
        rule.setIncomeEnd(param.getIncomeEnd());

        // 范围重叠验证
        List<IntegralTruckRule> list = integralTruckRuleDao.listAllRule();
        if (!list.isEmpty()) {
            if (list.get(0).getIntegralRatioBegin() == null
                    || list.get(0).getIntegralRatioBegin() == 0) {list.get(0).setIntegralRatioBegin(-1);}
            if (list.get(list.size()-1).getIntegralRatioEnd() == null
                    || list.get(list.size()-1).getIntegralRatioEnd() == 100){list.get(list.size()-1).setIntegralRatioEnd(101);}

            if (param.getIntegralRatioBegin() == null) {param.setIntegralRatioEnd(0);}
            if (param.getIntegralRatioEnd() == null){param.setIntegralRatioEnd(100);}

            for (IntegralTruckRule item : list) {
                if (item.getId().equals(rule.getId())) {continue;}
                if (item.getName().equals(param.getName())) {throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_NAME_EXIST);}

                if ((param.getIntegralRatioBegin().compareTo(item.getIntegralRatioBegin()) >= 0)
                        && (param.getIntegralRatioBegin().compareTo(item.getIntegralRatioEnd()) < 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }
                if ((param.getIntegralRatioEnd().compareTo(item.getIntegralRatioBegin()) > 0)
                        && (param.getIntegralRatioEnd().compareTo(item.getIntegralRatioEnd()) <= 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }

                if ((item.getIntegralRatioBegin().compareTo(param.getIntegralRatioBegin()) >= 0)
                        && (item.getIntegralRatioBegin().compareTo(param.getIntegralRatioEnd()) < 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }
                if ((item.getIntegralRatioEnd().compareTo(param.getIntegralRatioBegin()) > 0)
                        && (item.getIntegralRatioEnd().compareTo(param.getIntegralRatioEnd()) <= 0)){
                    throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_OVERLAP);
                }
            }
        }

        integralTruckRuleDao.update(rule);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRuleStatus(IntegralTruckRuleStatusUpdateParam param) {
        IntegralTruckRule rule = integralTruckRuleDao.getEntityByKey(param.getId()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        rule.setStatus(param.getStatus());

        integralTruckRuleDao.updateStatus(rule);

    }

    @Override
    public void deleteRule(IntegralTruckRuleStatusDeleteParam param) {
        integralTruckRuleDao.deleteByKey(param.getId());
    }

    @Override
    public AppIntegralTruckRuleVO getRuleInfo(Integer id) {
        IntegralTruckRule rule = integralTruckRuleDao.getEntityByKey(id).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        return integralTruckRuleStruct.convert(rule);
    }

    @Override
    public IPage<AppIntegralTruckRuleVO> pageRule(PageIntegralTruckRuleParam param) {
        return integralTruckRuleDao.pageRule(param);
    }

}
