package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyOrderChildConstants;
import com.clx.performance.service.OrderChildMqService;
import com.clx.performance.vo.mq.OrderChildAddMqParam;
import com.clx.performance.vo.mq.OrderChildDriverConfirmMqParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class OrderChildMqServiceImpl implements OrderChildMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void orderChildAdd(String childNo) {
        OrderChildAddMqParam mq = new OrderChildAddMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<OrderChildAddMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void orderChildDriverConfirm(String childNo) {
        OrderChildDriverConfirmMqParam mq = new OrderChildDriverConfirmMqParam();
        mq.setChildNo(childNo);

        MqDelay<MqWrapper<OrderChildDriverConfirmMqParam>> delay = new MqDelay<>(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.ORDER_CHILD_DRIVER_CONFIRM_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeyOrderChildConstants.DEFAULT_EXCHANGE, RabbitKeyOrderChildConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

}
