package com.clx.performance.model.integral;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 积分规则
* @Date: 2023/11/06 16:14:44
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class IntegralRule implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String orderChildCompleteRuleJson;      //运单完成积分规则
    private String orderAwardRuleJson;              //货单奖励积分规则
    private String orderDiscountRuleJson;           //货单扣减积分规则
    private String orderChildTimeoutRuleJson;       //运单超时扣减规则
    private String platformCompensationRuleJson;    //平台补偿积分规则
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}