package com.clx.performance.mapper.collect;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.collect.CollectTruckWait;
import com.clx.performance.param.app.collect.PageCollectTruckWaitParam;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam;
import com.clx.performance.sqlProvider.collect.CollectTruckWaitSqlProvider;
import com.clx.performance.vo.app.collect.CollectTruckWaitVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
* @Author: aiqinguo
* @Description: 线路排队耗时
* @Date: 2023/09/18 11:34:50
* @Version: 1.0
*/

@Mapper
public interface CollectTruckWaitMapper extends BaseMapper<CollectTruckWait> {
    /**
     * @see CollectTruckWaitSqlProvider#pageWaitReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.collect.PageCollectTruckWaitParam)
     */
    @SelectProvider(type = CollectTruckWaitSqlProvider.class, method = "pageWaitReport")
    IPage<CollectTruckWaitVO> pageWaitReport(@Param("page") Page<CollectTruckWaitVO> page, @Param("param") PageCollectTruckWaitParam param);
    /**
     * @see CollectTruckWaitSqlProvider#carrierPageWaitReport(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam)
     */
    @SelectProvider(type = CollectTruckWaitSqlProvider.class, method = "carrierPageWaitReport")
    IPage<CollectTruckWaitVO> carrierPageWaitReport(@Param("page") Page<CollectTruckWaitVO> page, @Param("param") CarrierPageCollectTruckWaitParam param);

}